<?php

namespace UtillzCore\Inc\Src;

use \UtillzCore\Inc\Src\Traits\Singleton;

class Importer {

    use Singleton;

    public $version = '1.0';
    public $is_active_envato_market = false;
    public $themes;
	public $menus = [
        'primary' => 'Primary',
    ];

    public $static_pages;

    public $system;

    function __construct() {
        $this->init_globals();
    }

    protected function init_globals() {

        $this->static_pages = apply_filters('utillz/import/static-pages', [
            'home_page_name' => 'Front Page',
            'blog_page_name' => 'Blog'
        ]);

        $this->system = [
            'execution' => [
                'id' => 'max_execution_time',
                'state' => ini_get('max_execution_time'),
                'recommended' => 120
            ],
            'memory' => [
                'id' => 'memory_limit',
                'state' => ini_get('memory_limit'),
                'recommended' => '128M'
            ],
            'post' => [
                'id' => 'post_max_size',
                'state' => ini_get('post_max_size'),
                'recommended' => '32M'
            ],
            'upload' => [
                'id' => 'upload_max_filesize',
                'state' => ini_get('upload_max_filesize'),
                'recommended' => '32M'
            ],
        ];

    }

    public function get_themes() {

        if( $this->is_active_envato_market = is_plugin_active('envato-market/envato-market.php') ) {
            return get_site_transient( envato_market()->get_option_name() . '_themes' );
        }

        return;

    }

    public function is_envato_verified() {

        if( defined('UTILLZ_VERIFIED') && UTILLZ_VERIFIED == true ) {
            return true;
        }

        $themes = $this->get_themes();

        if( isset( $themes['purchased'] ) ) {
            foreach( $themes['purchased'] as $purchased ) {
                if( $purchased['author'] == 'Utillz' ) {
                    return true;
                }
            }
        }

        return;

    }

    public function get_demos() {

        return apply_filters( 'utillz/importer/demos', [] );

    }

	public function wp_importer() {

        require_once( UTILLZ_CORE_PATH . 'inc/lib/wordpress-importer/wordpress-importer.php' );

        $wp_importer = new \WP_UTILLZ_Import();
        $wp_importer->fetch_attachments = true;

		return $wp_importer;
    }

}
